/*:
 * @target MZ
 * @plugindesc オプション画面を閉じたときに指定スイッチをONにする
 *
 * @param switchId
 * @text ONにするスイッチ
 * @type switch
 * @default 1
 */

(() => {
  const pluginName = document.currentScript.src.match(/([^\/]+)\.js$/)[1];
  const params = PluginManager.parameters(pluginName);
  const switchId = Number(params.switchId || 0);

  const _Scene_Options_popScene = Scene_Options.prototype.popScene;
  Scene_Options.prototype.popScene = function() {
    // タイトル画面からオプションを開いた場合など、$gameSwitches が無いケース対策
    if (switchId > 0 && window.$gameSwitches) {
      $gameSwitches.setValue(switchId, true);
    }
    _Scene_Options_popScene.call(this);
  };
})();
